/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.readers;

import eu.europa.ec.taxud.cesop.domain.XmlAddress;
import eu.europa.ec.taxud.cesop.domain.XmlCountryTypeAndValue;
import eu.europa.ec.taxud.cesop.domain.XmlDocSpec;
import eu.europa.ec.taxud.cesop.domain.XmlPsp;
import eu.europa.ec.taxud.cesop.domain.XmlReportedPayee;
import eu.europa.ec.taxud.cesop.domain.XmlTypeAndValue;
import eu.europa.ec.taxud.cesop.readers.CesopXmlReader;
import eu.europa.ec.taxud.cesop.utils.ValidationConstants;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;

public class ReportedPayeeXmlReader {
    private final CesopXmlReader cesopXmlReader;
    private final XmlReportedPayee xmlReportedPayee = new XmlReportedPayee();
    private static final String UNSPECIFIED_ADDRESS_TYPE = "CESOP309";

    public ReportedPayeeXmlReader(CesopXmlReader cesopXmlReader) {
        this.cesopXmlReader = cesopXmlReader;
    }

    public void parseFirstPart() throws XMLStreamException {
        if (!this.cesopXmlReader.positionCursorOnStartElement(ValidationConstants.XML.REPORTED_PAYEE_QNAME)) {
            throw new XMLStreamException("Tag " + ValidationConstants.XML.REPORTED_PAYEE_QNAME + " not found.");
        }
        this.cesopXmlReader.getXmlStreamReaderWrapper().moveToNextElement();
        this.xmlReportedPayee.setNames(this.parseNames());
        this.xmlReportedPayee.setCountry(this.parseCountry());
        this.xmlReportedPayee.setAddresses(this.parseAddresses(this.xmlReportedPayee.getCountry()));
        this.xmlReportedPayee.setEmailAddresses(this.parseEmailAddresses());
        this.xmlReportedPayee.setWebPages(this.parseWebPages());
        this.xmlReportedPayee.setVatIdentifications(this.parseVatIdentifications());
        this.xmlReportedPayee.setTaxIdentifications(this.parseTaxIdentifications());
        this.xmlReportedPayee.setAccountIdentifiers(this.parseAccountIdentifiers());
    }

    public void parseSecondPart() throws XMLStreamException {
        this.xmlReportedPayee.setRepresentative(this.parseRepresentative());
        this.xmlReportedPayee.setDocSpec(this.parseDocSpec());
    }

    private List<XmlTypeAndValue> parseNames() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        ArrayList<XmlTypeAndValue> names = new ArrayList<XmlTypeAndValue>();
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.NAME_QNAME)).isPresent()) {
            names.add(new XmlTypeAndValue(valuesMap.get().get("/Name@nameType"), valuesMap.get().get("/Name"), valuesMap.get().get("/Name@nameOther")));
        }
        return names;
    }

    private String parseCountry() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.COUNTRY_QNAME);
        return ValidationErrorUtils.convertGreece(valuesMap.get("/Country"));
    }

    private List<XmlAddress> parseAddresses(String defaultCountry) throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        ArrayList<XmlAddress> addresses = new ArrayList<XmlAddress>();
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.ADDRESS_QNAME)).isPresent()) {
            XmlAddress xmlAddress = new XmlAddress();
            xmlAddress.setLegalAddressType(valuesMap.get().get("/Address@legalAddressType") == null ? UNSPECIFIED_ADDRESS_TYPE : valuesMap.get().get("/Address@legalAddressType"));
            xmlAddress.setCountryCode(valuesMap.get().get("/Address/CountryCode") == null ? defaultCountry : ValidationErrorUtils.convertGreece(valuesMap.get().get("/Address/CountryCode")));
            xmlAddress.setStreet(valuesMap.get().get("/Address/AddressFix/Street"));
            xmlAddress.setBuildingIdentifier(valuesMap.get().get("/Address/AddressFix/BuildingIdentifier"));
            xmlAddress.setSuiteIdentifier(valuesMap.get().get("/Address/AddressFix/SuiteIdentifier"));
            xmlAddress.setFloorIdentifier(valuesMap.get().get("/Address/AddressFix/FloorIdentifier"));
            xmlAddress.setDistrictName(valuesMap.get().get("/Address/AddressFix/DistrictName"));
            xmlAddress.setPostOfficeBox(valuesMap.get().get("/Address/AddressFix/POB"));
            xmlAddress.setPostCode(valuesMap.get().get("/Address/AddressFix/PostCode"));
            xmlAddress.setCity(valuesMap.get().get("/Address/AddressFix/City"));
            xmlAddress.setCountrySubentity(valuesMap.get().get("/Address/AddressFix/CountrySubentity"));
            xmlAddress.setAddressFree(valuesMap.get().get("/Address/AddressFree"));
            addresses.add(xmlAddress);
        }
        return addresses;
    }

    private List<String> parseEmailAddresses() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        ArrayList<String> emailAddresses = new ArrayList<String>();
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.EMAIL_ADDRESS_QNAME)).isPresent()) {
            emailAddresses.add(valuesMap.get().get("/EmailAddress"));
        }
        return emailAddresses;
    }

    private List<String> parseWebPages() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        ArrayList<String> webPages = new ArrayList<String>();
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.WEBPAGE_QNAME)).isPresent()) {
            webPages.add(valuesMap.get().get("/WebPage"));
        }
        return webPages;
    }

    private List<XmlTypeAndValue> parseVatIdentifications() throws XMLStreamException {
        ArrayList<XmlTypeAndValue> vatIdentifications = new ArrayList<XmlTypeAndValue>();
        if (this.cesopXmlReader.positionCursorOnStartElement(ValidationConstants.XML.TAX_IDENTIFICATION_QNAME)) {
            Optional<Map<String, String>> valuesMap;
            this.cesopXmlReader.getXmlStreamReaderWrapper().moveToNextElement();
            while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.VAT_ID_QNAME)).isPresent()) {
                vatIdentifications.add(new XmlTypeAndValue(ValidationErrorUtils.convertGreece(valuesMap.get().get("/VATId@issuedBy")), valuesMap.get().get("/VATId")));
            }
        }
        return vatIdentifications;
    }

    private List<XmlCountryTypeAndValue> parseTaxIdentifications() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        ArrayList<XmlCountryTypeAndValue> taxIdentifications = new ArrayList<XmlCountryTypeAndValue>();
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.TAX_ID_QNAME)).isPresent()) {
            taxIdentifications.add(new XmlCountryTypeAndValue(ValidationErrorUtils.convertGreece(valuesMap.get().get("/TAXId@issuedBy")), valuesMap.get().get("/TAXId@type"), valuesMap.get().get("/TAXId"), valuesMap.get().get("/TAXId@TAXIdOther")));
        }
        return taxIdentifications;
    }

    private List<XmlCountryTypeAndValue> parseAccountIdentifiers() throws XMLStreamException {
        Optional<Map<String, String>> valuesMapOpt;
        ArrayList<XmlCountryTypeAndValue> accountIdentifiers = new ArrayList<XmlCountryTypeAndValue>();
        while ((valuesMapOpt = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.ACCOUNT_IDENTIFIER_QNAME)).isPresent()) {
            Map<String, String> valuesMap = valuesMapOpt.get();
            accountIdentifiers.add(new XmlCountryTypeAndValue(ValidationErrorUtils.convertGreece(valuesMap.get("/AccountIdentifier@CountryCode")), valuesMap.get("/AccountIdentifier@type"), valuesMap.get("/AccountIdentifier"), valuesMap.get("/AccountIdentifier@accountIdentifierOther")));
        }
        return accountIdentifiers;
    }

    private XmlPsp parseRepresentative() throws XMLStreamException {
        if (this.cesopXmlReader.positionCursorOnStartElement() && this.cesopXmlReader.getStartElementName().equals(ValidationConstants.XML.REPRESENTATIVE_QNAME)) {
            this.cesopXmlReader.getXmlStreamReaderWrapper().moveToNextElement();
            Optional<Map<String, String>> reportingPspMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.REPRESENTATIVE_ID_QNAME);
            if (reportingPspMap.isPresent()) {
                Optional<Map<String, String>> valuesMap;
                String pspIdType = reportingPspMap.get().get("/RepresentativeId@PSPIdType");
                String pspIdOther = reportingPspMap.get().get("/RepresentativeId@PSPIdOther");
                String pspId = reportingPspMap.get().get("/RepresentativeId");
                XmlPsp xmlReportingPsp = new XmlPsp(pspIdType, pspId, pspIdOther);
                while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.NAME_QNAME)).isPresent()) {
                    String pspNameType = valuesMap.get().get("/Name@nameType");
                    String pspNameOther = valuesMap.get().get("/Name@nameOther");
                    String pspName = valuesMap.get().get("/Name");
                    xmlReportingPsp.addName(pspNameType, pspName, pspNameOther);
                }
                return xmlReportingPsp;
            }
        }
        return null;
    }

    private XmlDocSpec parseDocSpec() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.DOC_SPEC_QNAME);
        XmlDocSpec xmlDocSpec = new XmlDocSpec();
        xmlDocSpec.setDocTypeIndic(valuesMap.get("/DocSpec/DocTypeIndic"));
        xmlDocSpec.setDocRefId(valuesMap.get("/DocSpec/DocRefId"));
        xmlDocSpec.setCorrMessageRefId(valuesMap.get("/DocSpec/CorrMessageRefId"));
        xmlDocSpec.setCorrDocRefId(valuesMap.get("/DocSpec/CorrDocRefId"));
        return xmlDocSpec;
    }

    public XmlReportedPayee getXmlReportedPayee() {
        return this.xmlReportedPayee;
    }
}

